import { system, world } from '@minecraft/server';
import { Vec3 } from '../utils/Vec3.js';
class Vulture {
  static TYPE_ID = 'sf_nba:vulture';
  static CACTUS_TYPE_ID = 'minecraft:cactus';
  constructor() {
    this.tryToSitOnCactusGoal();
  }
  tryToSitOnCactusGoal() {
    world.afterEvents.dataDrivenEntityTrigger.subscribe(({ entity: vulture }) => {
      try {
        const { dimension, location } = vulture;
        const isOnCactusTop = dimension.getBlock(Vec3.fromMinecraftVector3(location).add(new Vec3(0, -1.5, 0)))?.typeId === Vulture.CACTUS_TYPE_ID;
        if (!isOnCactusTop) return;
        if (dimension.getEntities({ location, type: vulture.typeId, maxDistance: 1, propertyOptions: [{ propertyId: 'sf_nba:is_sitting', value: true }] }).length) {
          return;
        }
        vulture.triggerEvent('sf_nba:start_sitting');
      } catch {}
    },
    {
      entityTypes: [Vulture.TYPE_ID],
      eventTypes: ['sf_nba:vulture_try_to_sit_on_cactus']
    });
  }
}
new Vulture();